function DoAll

%Structure of this file:
% 1)Main Part
% 2)FrequencyAnalysis uses fft to decompose signal into frequency bands.
% Results are moy_bands and bands which are respectively the global mean
% over all samples and electrodes and the mean over each electrodes

% 3)Rythme does exactly the same but using pwelch
% 4)Inverse computes the inverse problem over 400 sources
% 5)SendOSCMessage sends raw data with labels of each electrodes as a header
% 6)SendOSCMessageBands sends one value per band
% 7)SendOSCMessageRythmes sends values on each electrodes per band
% author: R.Lehembre, lehembre@tele.ucl.ac.be
load pGFor18electrodes

Bits = 8
ech = 64
canaux = 18

adresseJJ = '192.168.3.102';
adresseAB = '192.168.3.101';
head = '/data';

tailleMessage = Bits*ech*canaux  %8bits*freq_ech*nbre_canaux : size of received packet
Elec_name = ['/F2';'/F1';'/F8';'/F4';'/FZ';'/F3';'/F7';'/T4';'/C4';'/C3';'/T3';'/T6';'/P4';'/PZ';'/P3';'/T5';'/O2';'/O1'];
Elec_freq = ['/EF2';'/EF1';'/EF8';'/EF4';'/EFZ';'/EF3';'/EF7';'/ET4';'/EC4';'/EC3';'/ET3';'/ET6';'/EP4';'/EPZ';'/EP3';'/ET5';'/EO2';'/EO1'];
moy_rythmes = ['/delta';'/theta';'/alpha';'/betaa';'/muuuu';'/eyess'];
Rythmes = ['/Rythme1';'/Rythme2';'/Rythme3';'/Rythme4'];
Zones = ['/acog';'/visu';'/smcl';'/smcr'];
Zones2 = ['/acogAlpha';'/visuAlpha';'/smclAlpha';'/smcrAlpha'];
%Main Part : Endless Iteration receiving packets from medicalStudio,
%treating them and then sending results to max-msp



%%%%%%%%%%%%%%%%%%%%%%%%%%%    MAIN PART   %%%%%%%%%%%%%%%%%%%%%
while 1

    
    pnet('closeall');
    udp=pnet('udpsocket',8000);
    tic
    try,
%display('fuck&1suck&2')
        %  display('képassa aqui');
        len=pnet(udp,'readpacket',tailleMessage);
        data=pnet(udp,'read',[ech canaux],'double');
        receive = data;
        size(receive);
        % display('képassa aqui99');
    catch,
        error(1,'Error with UDP');
    end
    %[All1  All2  All3] = Rythmes(receive);
    %         fddgslmjdhgl = size(All2);
    %         %A= [0::1]
    %         %close all
    %         figure(2)
    %         hold on
    %         plot(All2(1,:))
    %         plot(All2(2,:)+1)
    %         plot(All2(2,:)+2)
    %         plot(All2(2,:)+3)
    %         hold off
    [moy_bands, bands , Pyy, entropie, Spec_edge] = FrequencyAnalysis(receive);
    [FourParts,FourPartsAlpha] =  Inverse(data,pG,X,Y,Z);
    %pause(0.05)
    %Pyy = char(Pyy);
    tmp=1;
    PuissBand = zeros(16,canaux);
    for i=1:2:32
        PuissBand(tmp,:) = (Pyy(i,:)+Pyy(i+1,:))/2;
        tmp = tmp+1;
    end
    
    moy_bands = moy_bands';
    %pause(2)
    FourParts = FourParts';
    FourPartsAlpha = FourPartsAlpha';
    
    SpecialTongue = max(receive(:,3));
    if SpecialTongue>15000
        Tong = 2;
    elseif SpecialTongue >8000
        Tong = 1;
    else
        Tong = 0;
    end
    
    %send=SendAnyOSCMessage(adresse,port,header,data); 
    %Header : size = [canaux,letters] 
    %Data :  size = [ech, canaux]
    %Canaux should be the same for both of them
    
    %ca c bon
    send=SendAnyOSCMessage(adresseJJ,7000,Elec_name,data); 
    send=SendAnyOSCMessage(adresseJJ,7001,moy_rythmes,moy_bands);
    send=SendAnyOSCMessage(adresseJJ,7002,Rythmes,bands);
    send=SendAnyOSCMessage(adresseJJ,7004,Elec_freq,Pyy(1:32,:));
    send = SendOSCMessage(adresseJJ,7005,'/entropie',entropie);
    send=SendAnyOSCMessage(adresseJJ,7006,Zones,FourParts);
    send = SendOSCMessage(adresseJJ,7007,'/Spec',Spec_edge);
    send=SendAnyOSCMessage(adresseJJ,7008,Zones2,FourPartsAlpha);
    send = SendOSCMessage(adresseJJ,7009,'/Speciall',Tong);
    
    send=SendAnyOSCMessage(adresseAB,7000,Elec_name,data); 
    send=SendAnyOSCMessage(adresseAB,7001,moy_rythmes,moy_bands);
    send=SendAnyOSCMessage(adresseAB,7002,Rythmes,bands);
    send=SendAnyOSCMessage(adresseAB,7004,Elec_freq,PuissBand);
    send = SendOSCMessage(adresseAB,7005,'/entropie',entropie);
    send=SendAnyOSCMessage(adresseAB,7006,Zones,FourParts);
    send = SendOSCMessage(adresseAB,7007,'/Spec',Spec_edge);
    send=SendAnyOSCMessage(adresseAB,7008,Zones2,FourPartsAlpha);
    send = SendOSCMessage(adresseAB,7009,'/Speciall',Tong);
    

%     
  
    

    %send = SendOSCMessageFreqElec(adresseAB,7004,head,Pyy);
    %send = SendOSCMessageFreqElec(adresseJJ,7004,head,Pyy);
   % size('/entropie')
   % size(entropie)
   %  send = SendOSCMessage(adresseJJ,7005,'/entropie',entropie);
     %send = SendOSCAnyMessage(adresseAB,7005,'/entropie',entropie);
     %size('/Spec_edge')
     %size(Spec_edge)
    % pause(10)
   %  send = SendAnyOSCMessage(adresseJJ,7006,'/Spec',Spec_edge);
     %send = SendOSCMessage(adresseAB,7006,'/Spec',Spec_edge);
    %load pGFor18electrodes
    % activmoy =  Inverse(receive,pG,X,Y,Z);
    %display('shit');
    toc
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [moy_bands, bands, Pyy, entropie, Spec_edge] = FrequencyAnalysis(data)

[ech,canaux] = size(data)
if ech~=64
data = resample(data,64,ech)
end
%Fast Fourier Transform
for i =1:canaux
    Y(:,i) = fft(data(:,i),64);
    Pyy(:,i) = Y(:,i).* conj(Y(:,i)) / 64;
end
%Pyy = Y.* conj(Y) / 64;
f = 64*(0:32)/64; %fs
hgsfh=size(Pyy);
Pyy_norm = Pyy./max(max(Pyy));

%Spectral Entropy
for i=1:18
    for j = 1:33
        SpEn_tmp(i,j) = Pyy_norm(j,i)*log2(Pyy_norm(j,i));
    end
    SpEn(i) = -sum(SpEn_tmp(:,i));  %SpectralEntropy
end
superENtropie = size(SpEn);
entropie=SpEn;


%Spectral edge : fréquence sous laquelle on trouve 95% de l'energie du
%signal

for i =1:canaux
    somme = 0;
    ak = 2;
%NRJ_tot(i) = sum(Pyy(:,i))
Puiss(i) = quantile(Pyy(1:32,i),0.95);
while somme < Puiss(i)
    somme = Pyy(ak,i)+somme;
    ak = ak+1;
end
Spec_edge(i) = ak;
end
Spec_edge;


% figure(3)
% hold on
% for i=1:18
%     plot(f,Pyy(1:33,i)-i*100)
% end
% hold off

%electrodes used for alpha waves : 12:18
delta = f(2:5);
theta = f(5:9);
alpha = f(9:13);
beta = f(13:17);

normO1 = Pyy(alpha,17)/max(Pyy(alpha,17));
%size(normO1)
normO2 = Pyy(alpha,18)/max(Pyy(alpha,18));;

moy_eyes = mean(normO1)+mean(normO2); %;

moy_mu = (mean(Pyy(alpha,9))-mean(Pyy(alpha,10))) / (mean(Pyy(alpha,9))+mean(Pyy(alpha,10)));

moy_delta =mean(mean(Pyy(delta,:)./max(max(Pyy(delta,:)))));
moy_theta =mean(mean(Pyy(theta,3:9)./max(max(Pyy(theta,:)))));
moy_alpha =mean(mean(Pyy(alpha,12:18)./max(max(Pyy(alpha,:)))));
moy_beta = mean(mean(Pyy(beta,12:18)./max(max(Pyy(beta,:)))));


delta =mean(Pyy(delta,1:7));
theta =mean(Pyy(theta,8:14));
alpha =mean(Pyy(alpha,12:18));
beta = mean(Pyy(beta,12:18));

size(delta);

moy_bands = [moy_delta; moy_theta; moy_alpha; moy_beta; moy_mu; moy_eyes];
size(moy_bands);
bands = [delta; theta; alpha; beta];
bands = bands';
Pyy;
Spec_edge;
%Pause(4)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function  [All1  All2  All3] = Rythmes(receive)

signal = receive;
[ech,canaux]=size(signal);
ech2 = 4*ech;
puiss = zeros(ech2,canaux);
for i=1:18
    [Pxx,Fx]=pwelch(signal(:,i),16,1,[],64,'twosided');
    puiss(:,i)=Pxx;
end
%Computation of different rythms (Fx = 0:0.25:64 i.e size Fx = 256)

delta = puiss(1:16,:);%calculation of delta band [0-4]Hz
theta = puiss(17:32,:);%theta band [4-8]Hz
alpha = puiss(33:48,:);%alpha band [8-12]Hz
beta = puiss(71:86,:);%beta band [16-24]Hz

% haha=size(delta)
% haha=size(theta)
% haha=size(alpha)
% haha=size(beta)
%mean over all the samples
s_delta = mean(delta)./max(delta);
s_theta = mean(theta)./max(theta);
s_alpha = mean(alpha)./max(alpha);
s_beta = mean(beta)./max(beta);


%mean over all electrodes
m_delta = mean(mean(delta/max(delta)));
m_theta = mean(mean(theta/max(theta)));
m_alphaa = mean(mean(alpha/max(alpha)));

%gaga = size(alpha(:,17))
normO1 = alpha(:,1)/max(alpha(:,1));
%size(normO1)
normO2 = alpha(:,1)/max(alpha(:,1));
eyes = mean(normO1(:,1)./max(normO1(:,1)))+mean(normO2(:,1)./max(normO2(:,1))); % signal from O1 & O2

m_beta = mean(mean(beta/max(beta)));


mu = (mean(alpha(:,10))-mean(alpha(:,9)))/(mean(alpha(:,10))+mean(alpha(:,9)));%

All1 = [m_delta; m_theta; m_alphaa; m_beta; mu; eyes];%[1,1] valeur chaque
All2 = [s_delta; s_theta; s_alpha; s_beta];%[1,canaux]
All3 = [delta; theta; alpha; beta];%[ech,canaux]
%bl = size(All3)








%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%ù
function [FourParts,FourPartsAlpha] =  Inverse(data,pG,X,Y,Z)

%if click < 5
%base=mean(volt,2); %Take off the first seconds as noise
%save('base.mat','base');
%end

%base=1;
%[nelec,npack]=size(volt);

% Lx = block.DialogPrm(1).Data;
% Ly = block.DialogPrm(2).Data;
% Lz = block.DialogPrm(3).Data;
% pG = block.DialogPrm(4).Data;




scl1=2.4;% scale factors
scl2=4.0;
swhead=0;
%area
acog=[2:8 12:18 20:26 30:36 38:44 326:332 336:342 344:350 354:360];
visu=[146:152 156:162 164:170 174:180 182:188 192:198 200:206 210:216 218:224];
smcl=[87:91 95:101 105:109 113:119 123:127];
smcr=[248:253 256:263 266:271 274:281 284:289];

size_acog = max(size(acog));
size_visu = max(size(visu));
size_smcl = max(size(smcl));
size_smcr = max(size(smcr));
%if mod(tatou,10)>0
%load pG;
%load sphlocations;
%load base;
%     Lx = block.DialogPrm(1).Data;
%     Ly = block.DialogPrm(2).Data;
%     Lz = block.DialogPrm(3).Data;
%     pG = block.DialogPrm(4).Data;
%     base = block.DialogPrm(8).Data;

%data=volt-ones(nelec,npack)*mean(mean(volt))-base*ones(1,npack);
%data=volt-ones(nelec,npack)*mean(mean(volt));
size(pG);
size(data);
sol=pG*data';



sol2 = sol';

[ech,source] =size(sol2);
if ech~=64
data = resample(sol2,64,ech)
end
%Fast Fourier Transform
for i =1:source
    Y2(:,i) = fft(sol2(:,i),64);
    Pyy2(:,i) = Y2(:,i).* conj(Y2(:,i)) / 64;
end
%Pyy = Y.* conj(Y) / 64;
f = 64*(0:32)/64; %fs
hgsfh=size(Pyy2);
Pyy2_norm = Pyy2./max(max(Pyy2));

delta = f(2:5);
theta = f(5:9);
alpha = f(9:13);
beta = f(13:17);

acog_alpha = mean(mean(Pyy2_norm(alpha,acog)));
visu_alpha = mean(mean(Pyy2_norm(alpha,visu)));
smcl_alpha = mean(mean(Pyy2_norm(alpha,smcl)));
smcr_alpha = mean(mean(Pyy2_norm(alpha,smcr)));

mean_acog = mean(mean(sol2(:,acog)));
mean_visu = mean(mean(sol2(:,visu)));
mean_smcl = mean(mean(sol2(:,smcl)));
mean_smcr = mean(mean(sol2(:,smcr)));

FourParts = [mean_acog; mean_visu; mean_smcl; mean_smcr];
FourPartsAlpha = [acog_alpha; visu_alpha; smcl_alpha; smcr_alpha];
Pyy2_norm =Pyy2_norm';
%F = mymovie4(X,Y,Z,sol)
%showme3(Lx,Ly,Lz,sol,swhead,tx2,ty2,tz2); %show the result
%sdvisu=(mean(mean(sol(visu,:)))+scl1)/scl2 % take the mean power
% and scale the data
%sdcog=(mean(mean(sol(acog,:)))+scl1)/scl2
%sdsmcl=(mean(mean(sol(smcl,:)))+scl1)/scl2
%sdsmcr=(mean(mean(sol(smcr,:)))+scl1)/scl2

%     sendmat(remotehost,port,'/visu','f',1,sdvisu);%send the data
%     sendmat(remotehost,port,'/cog','f',1,sdcog);
%     sendmat(remotehost,port,'/smcl','f',1,sdsmcl);
%     sendmat(remotehost,port,'/smcr','f',1,sdsmcr);
%else
%     base=mean(volt,2); %Take off the first seconds as noise
%     save('/export/MatCom/EEGproc/base.mat','base');
%   end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function F=mymovie4(x,y,z,data)
% function F=mymovie4(x,y,z,data)
% Show the data as a movie
% INPUT:
% - x,y,z: matrices of size st x sp of the dipoles location (respectively x,y,z
% coordinates)
% - data: nd x t matrix with nd number of dipoles and t number of times samples, dipoles amplitudes along the time
% OUTPUT:
% - F: matlab movie. To watch it
%      >> h=figure('Position',[1 600 800 600])
%      >> movie(h,F,1,2)
%      with h the handler, 1 the number of time we want to see the movie
%      and 2 the number of frame by second.
% - Display the movie on the screen during the recording

RSPH=0.075;% sphere radius

data = mean(data,2)
[nsol time]=size(data)
%data2 = mean(data,2);
%data = [data2 data2]
%sdqgfhgdfhgs= size(data)
[st sp]=size(x);
F=0;
maxi=max(max(data))/10;
mini=min(min(data))/10;
%maxi = 1;
%mini = 0;
%mov = avifile('example.avi');
Colo=zeros(st+1,sp+1);
X=zeros(st+1,sp+1);
Y=zeros(st+1,sp+1);
Z=zeros(st+1,sp+1);
X(1:st,1:sp)=x;
X(:,sp+1)=0;
X(st+1,:)=X(1,:);
Y(1:st,1:sp)=y;
Y(:,sp+1)=0;
Y(st+1,:)=Y(1,:);
Z(1:st,1:sp)=z;
Z(:,sp+1)=RSPH;
Z(st+1,:)=Z(1,:);
%figure('Position',[1 600 800 600]);
for k=1:time
    Colo(:,sp+1)=mean(data(st:st:nsol,k));  % top point
    npt=1;
    for i=0:st-1
        for j=0:sp-1
            Colo(i+1,j+1)=data(npt,k);
            npt=npt+1;
        end
    end
    Colo(st+1,:)=Colo(1,:);

    figure(1)
    surf(X,Y,Z,Colo);
    caxis([0,2])
    shading interp
    title(['Top ',int2str(k)]);
    view(-90,90)
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function send=SendAnyOSCMessage(address,port,head,data)

% List of electrodes
%Str = ['/E1';'/E2';'/E3';'/E4';'/E5';'/E6';'/E7';'/E8';'/E9';'/E10';'/E11';'/E12';'/E13';'/E14';'/E15';'/E16';'/E17';'/E18'];
%Str = ['/EF2';'/EF1';'/EF8';'/EF4';'/EFZ';'/EF3';'/EF7';'/ET4';'/EC4';'/EC3';'/ET3';'/ET6';'/EP4';'/EPZ';'/EP3';'/ET5';'/EO2';'/EO1'];
%taillecasque =  size(Str) ;
%address
%port
%head
%data
% function send=SendOSCMessage(address,port,head,data)
% Encapsulate head and data in OSC protocol then send it with UPD
% UDP function used is pnet from TCP_UDP_IP toolbox
% INPUT:
% - address: string with IP address (ex: 10.104.11.14)
% - port: int, port number to connect, default= 7770
% - head: head of the OSC protocol must start with '/'
% - data: float vector of data (single matlab type)
% OUTPUT:
% - size: the size of the sent data
%Str = head
[can, lett] = size(head);
[ech,canaux]=size(data);

pnet('closeall');
udp=pnet('udpsocket',3333); %default port to send data. should be changed
daze = ech;

%data = int(data)
for j=1:canaux
    header = head(j,1:lett);
    %header = head2;

    %display('alrededor')

    pnet(udp,'write',header);
    temp1=mod(max(size(header)),4); % check number of zero to add
    temp2=4-temp1-1; % number of zero to add

    pnet(udp,'write',uint8(0)); % mandatory zero to finish the string
    for i=1:temp2 % add zero at the end to get a multiple of 4
        pnet(udp,'write',uint8(0));
    end
    pnet(udp,'write',','); % comma to start the type tag

    for i=1:ech
        pnet(udp,'write','f'); % number of float to write
    end

    pnet(udp,'write',uint8(0)); % mandatory zero to finish the typetag string
    temp1=mod(daze+2,4); % check number of zero to add
    if temp1>0
        temp2=4-temp1; % number of zero to add
        for i=1:temp2 % add zero at the end to get a multiple of 4
            pnet(udp,'write',uint8(0));
        end
    end

 
    for i=1:ech % write the data
        %round(data(i,j))
        pnet(udp,'write',single(data(i,j)));
    end

    %end
    send=pnet(udp,'writepacket',address,port);
    mic = size(send);
end
pnet('closeall');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%ù
function send=SendOSCMessage(address,port,head,data)

%address
%port
%head
%data
% function send=SendOSCMessage(address,port,head,data)
% Encapsulate head and data in OSC protocol then send it with UPD
% UDP function used is pnet from TCP_UDP_IP toolbox
% INPUT:
% - address: string with IP address (ex: 10.104.11.14)
% - port: int, port number to connect, default= 7770
% - head: head of the OSC protocol must start with '/'
% - data: float vector of data (single matlab type)
% OUTPUT:
% - size: the size of the sent data

daze=max(size(data));
pnet('closeall');
%display('alrededor')
udp=pnet('udpsocket',3333); %default port to send data. should be changed
pnet(udp,'write',head);
temp1=mod(max(size(head)),4); % check number of zero to add
temp2=4-temp1-1; % number of zero to add
pnet(udp,'write',uint8(0)); % mandatory zero to finish the string
for i=1:temp2 % add zero at the end to get a multiple of 4
    pnet(udp,'write',uint8(0));
end
pnet(udp,'write',','); % comma to start the type tag
for i=1:daze
    pnet(udp,'write','f'); % number of float to write
end
pnet(udp,'write',uint8(0)); % mandatory zero to finish the typetag string
temp1=mod(daze+2,4); % check number of zero to add
if temp1>0
    temp2=4-temp1; % number of zero to add
    for i=1:temp2 % add zero at the end to get a multiple of 4
        pnet(udp,'write',uint8(0));
    end
end
for i=1:daze % write the data
    pnet(udp,'write',single(data(i)));
end
send=pnet(udp,'writepacket',address,port);
mic = size(send);
